/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
/// ' Microsoft Content Management Server - Sample Code 
/// '
///	' This sample code is provided "AS IS" with no warranties, and confers no rights. 
/// ' You assume all risk for your use.  2002 Microsoft Corporation. All rights reserved.
/// '
/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		
using System;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.ComponentModel;
using System.ComponentModel.Design;
//Add reference to the Mcms control library
using McmsSpsWebControlLibrary;

namespace McmsSpsWebControlLibrary.Design 
{
	public class McmsBreadcrumbDesigner : ControlDesigner 
	{
				
		/// <summary>
		/// 
		/// 
		#region Public functions
		///		Get design time HTML.
		///		This HTML appears in design view in GUI editors.
		/// </summary>
		public override string GetDesignTimeHtml() 
		{
			System.IO.StringWriter text = new System.IO.StringWriter();
			HtmlTextWriter writer = new HtmlTextWriter(text);
			
			//Read in class for control
			writer.Write("<div class='" + breadcrumbControl.CssClass + "'>");			
			//Use the DesignText property for design-time display
			writer.Write(breadcrumbControl.DesignText);
			writer.Write("</div>");

			//Call GetPersistInnerHtml() to update inner HTML
			GetPersistInnerHtml();

			return text.ToString();
		}



		private McmsBreadcrumbControl breadcrumbControl;
		/// <summary>
		///		Initialization routine. Captures the component and casts it to our object. 
		/// </summary>
		public override void Initialize(IComponent component)
		{
			base.Initialize(component);
			breadcrumbControl = (McmsBreadcrumbControl) component;

		}

		#endregion Public functions
	} //Close Class
} //Close Namespace

//EOF - SC - Jan 2002
